#include <applications/dialog/HomeDialog.h>
#include <applications/dialog/SplashDialog.h>
#include <hal/devices.h>
#include <cstdio>
#include <hal/timer.h>
#include <hal/drivers/flash.h>
#include <applications/dialog/ContrastDialog.h>
#include <hal/drivers/buzzer.h>

CSplashDialog SplashDialog;

static int on_time(int argc, char *argv[])
{
	beep(200);
	p_dialog = &HomeDialog;
	p_dialog->OnCreat();
}

void CSplashDialog::OnButtonDown(void)
{
	timer t;
	t.time = 100;
	t.timer_app.argc = 0;
	t.timer_app.fun = on_time;

	delete_timer(t);

	beep(100, 100, 100);
	p_dialog = &ContrastDialog;
	p_dialog->OnCreat();
}

void CSplashDialog::OnCreat(void)
{
	rewind(p_lcd);

	fputs(" ANALOG DEVICES ", p_lcd);
	fputs("AHEAD OF WHAT'S ", p_lcd);
	fputs("    POSSIBLE    ", p_lcd);
	fputs("EVAL-CN0359-EB1Z", p_lcd);

	fflush(p_lcd);

	timer t;
	t.time = 3000;
	t.timer_app.argc = 0;
	t.timer_app.fun = on_time;
	t.timer_app.argv = new char*;

	new_timer(t);
}

